function [As,l0s] = jump_tic(ahat,R,nu,N)
% -------------------------------------------------------------------------
% jump_tic.m        Independence chain jumping distribution from a t
%                   distribution. 
% -------------------------------------------------------------------------
% K Jagan, A B Forbes, NPL, www.npl.co.uk
% -------------------------------------------------------------------------
% Inputs:
% ahat(n,1)         Non-linear least squares estimate of model parameters.
% L(n,n)            Cholesky factor of the variance of the parameter
%                   vector.
% nu                Degrees of freedom of the t jumping distribution.
% N                 Number of parallel chains.
% Outputs:
% As(n,N)           Proposed parameter array which is randomly sampled from
%                   the jumping distribution.
% l0s               Log of the jumping distribution evaluated at As. 
% -------------------------------------------------------------------------
% [As,l0s] = jump_tic(ahat,R,nu,N)
% -------------------------------------------------------------------------
  n = length(ahat);
 
% Mean of the t jumping distribution 
  A0 = ahat*ones(1,N);

% Correlation matrix 
  C = eye(n);

% Proposal draws from the t jumping distribution 
  E = mvtrnd(C,nu,N)';
  As = A0 + R\E;
 
% Log of the jumping distribution 
  Aas = R*(As - A0);
  l0s = log(mvtpdf(Aas',C,nu))';
% -------------------------------------------------------------------------
% End of jump_tic.m
% -------------------------------------------------------------------------
end 