function [As, dp0] = jumprwg(A, L)
% -------------------------------------------------------------------------
% jumprwg.m         Jumping distribution for the Metropolis Hastings
%                   Gaussian random walk algorithm.
%                   To be used as function handle within mcmcmh.m.
%                   @(A)jumprwg(A,L).
% -------------------------------------------------------------------------
% K Jagan, A B Forbes, NPL, www.npl.co.uk
% -------------------------------------------------------------------------
% Inputs:
% A(n,N)            Samples at the current iteration.
% L(n,n)            Cholesky factor of variance of parameter vector.
% Outputs:
% As(n,N)           Proposed parameter array which is randomly sampled
%                   from the jumping distribution.
% dp0               The difference between the logarithm of the
%                   jumping distribution associated with moving from
%                   A(:,j) to As(:,j) and that associated with moving
%                   from As(:,j) to A(:,j), up to an additive constant
%                   log P0(a|as) - log P0(as|a).
% -------------------------------------------------------------------------
% [As, dp0] = jumprwg(A, L)
% -------------------------------------------------------------------------

% number of parameters and parallel chains
  [n, N] = size(A);

% random draw from a Gaussian distribution
  e = randn(n, N);

% proposed draw from a Gaussian distribution with mean A and variance LL'
  As = A + L*e;

% for a Gaussian random walk, since log P0(a|as) = log P0(as|a),
% dp0 will always be zero
  dp0 = zeros(1, N);
  
% -------------------------------------------------------------------------
% End of jumprwg.m
% -------------------------------------------------------------------------
end