%% Function to display calculation tableau for weighted least squares (WLS)
function write_wls_tableau(x, y, w, g0, h0, g, h, a, b, r, fstr)

%%
m  = length(x);
C1 = [0, 0, 0, 0, g0, h0, 0, 0, a, 0];
C2 = [w, w.*w, w.*w.*x, w.*w.*y, g, h, g.*g, g.*h, r, r.*r];
C3 = sum(C2);
C3(1) = 0;
C3(5) = 0;
C3(6) = 0;
C3(9) = b;
Ca = [C1; C2; C3]; 
fprintf('Calculation tableau \n')
for i = 1:m+2
  fprintf([fstr, fstr, fstr, fstr, fstr, fstr, fstr, fstr, fstr, fstr, '\n'], Ca(i, :)) 
end 
fprintf('\n')

%%
% End of write_wls_tableau.m