%% Function to display calculation tableau for Gauss Markov regression (GMR)
function write_gmr_tableaux(f, g, h, g0, h0, gt, ht, a, b, r, fstr)

%%
% Initial calculation tableau.
fprintf('Initial calculation tableau \n')
m = length(f);
for i = 1:m
  fprintf([fstr, fstr, fstr, '\n'], f(i), g(i), h(i)) 
end 
fprintf('\n')

%%
% Main calculation tableau. 
C1 = [0, 0, 0, g0, h0, 0, 0, a, 0];
C2 = [f.*f f.*g f.*h gt ht gt.*gt gt.*ht r r.*r];
C3 = sum(C2);
C3(4) = 0;
C3(5) = 0;
C3(8) = b;
Ca = [C1; C2; C3]; 
fprintf('Main calculation tableau \n')
for i = 1:m+2
  fprintf([fstr, fstr, fstr, fstr, fstr, fstr, fstr, fstr, fstr, '\n'], Ca(i, :)) 
end 
fprintf('\n')

%%
% End of write_gmr_tableaux.m