%% Function to display calculation tableau for generalized Gauss Markov regression (GMR)
function write_ggmr_tableau(tt, dt, ind, fstr)

%%
m  = length(tt{1})-2;
TT = zeros(m+2, ind+2); 
TT(:, 1) = tt{1}; 
str = fstr; 
for niter = 1:ind
  TT(:, niter+1) = dt{niter}; 
  str = [str, fstr];  %#ok<AGROW>
end 
TT(:, ind+2) = tt{ind+1}; 
str = [str, fstr, '\n']; 
fprintf('Summary of iterative procedure (initial approximations, corrections and final estimates) \n')
for i = 1:m+2
  fprintf(str, TT(i, :)) 
end 
fprintf('\n')

%%
% End of write_ggmr_tableau.m