%% Function to display calculation tableau for generalized distance regression (GDR)
function write_gdr2_tableaux(x, ux, y, uy, uxy, t, xs, z, f, g, h, g0, h0, gt, ht, ...
                           at, bt, da, db, r, niter, fstr)

%%
m  = length(x);
Ci = [0,  0, 0,  0,   0, at{niter}, bt{niter},        0,        0,        0,        0;
      x, ux, y, uy, uxy,  t{niter}, xs{niter}, z{niter}, f{niter}, g{niter}, h{niter}]; 
fprintf(['Iteration ', num2str(niter),' to determine fi, gi, and hi \n'])
for i = 1:m+1
  fprintf([fstr fstr fstr fstr fstr fstr fstr fstr fstr fstr fstr, '\n'], Ci(i, :)) 
end 
disp(' ')
C1 = [0, 0, 0, g0{niter}, h0{niter}, 0, 0, da{niter}, 0];
C2 = [f{niter}.*f{niter}, f{niter}.*g{niter}, f{niter}.*h{niter}, gt{niter}, ht{niter}, ...
      gt{niter}.*gt{niter}, gt{niter}.*ht{niter}, r{niter}, r{niter}.*r{niter}];
C3 = sum(C2);
C3(4) = 0;
C3(5) = 0;
C3(8) = db{niter};
Ca = [C1; C2; C3]; 
fprintf(['Iteration ', num2str(niter),' to determine increments deltaa and deltab \n'])
for i = 1:m+2
  fprintf([fstr fstr fstr fstr fstr fstr fstr fstr fstr, '\n'], Ca(i, :)) 
end 
fprintf('\n')

%%
% End of write_gdr2_tableaux.m