%% Function to solve the weighted least squares (WLS) problem (Clause 6)
function [a, b, u2a, u2b, uab, w, g0, h0, g, h, G2, r, R] = algm_wls_steps_1_to_8(x, y, uy)

%%
% Step 1. 
m = length(x);
w = ones(m, 1)./uy;
F2 = sum(w.*w);

%%
% Step 2. 
g0 = (sum(w.*w.*x))/F2; 
h0 = (sum(w.*w.*y))/F2; 

%%
% Step 3. 
g = w.*(x - g0); 
h = w.*(y - h0); 

%%
% Step 4. 
G2 = sum(g.*g); 

%%
% Step 5. 
b = (sum(g.*h))/G2; 
a = h0 - b*g0; 

%%
% Step 6. 
u2a = 1/F2 + (g0^2)/G2; 
u2b = 1/G2; 
uab = -g0/G2; 

%%
% Step 7. 
r = w.*(y - a - b*x); 

%%
% Step 8. 
R = sum(r.*r); 

%%
% End of algm_wls_steps_1_to_8.m