%% Function to undertake steps 2 to 8 of the GGMR algorithm (Annex C)
function [tt, dt, f, J, Q, R1, T, Z, ft1, ft2, T11, T12, T22, et2] = ...
  algm_ggmr_orthogonal_steps_2_to_8(x, y, B, tt, dt, f, J, Q, R1, T, Z, ...
    ft1, ft2, T11, T12, T22, et2, ind)

%%
% Step 2. 
m = length(x); 
f{ind} = [x - tt{ind}(1:m); 
          y - (tt{ind}(m+1) + tt{ind}(m+2)*tt{ind}(1:m))]; 
J{ind} = [-eye(m), zeros(m, 2); 
          -tt{ind}(m+2)*eye(m), -ones(m, 1), -tt{ind}(1:m)]; 

%%
% Step 3. 
[Q{ind}, R10{ind}] = qr(J{ind}); 
R1{ind} = R10{ind}(1:m+2, 1:m+2); 

%%
% Step 4. 
[T{ind}, Z{ind}] = rq(Q{ind}'*B); 

%%
% Step 5. 
p = size(B, 2);   
ft{ind} = Q{ind}'*f{ind}; 
ft1{ind} = ft{ind}(1:m+2); 
ft2{ind} = ft{ind}(m+3:2*m); 
T11{ind} = T{ind}(1:m+2, 1:p-m+2); 
T12{ind} = T{ind}(1:m+2, p-m+3:p); 
T22{ind} = T{ind}(m+3:2*m, p-m+3:p); 

%%
% Step 6. 
et2{ind} = T22{ind}\ft2{ind}; 

%%
% Step 7. 
dt{ind} = R1{ind}\(T12{ind}*et2{ind} - ft1{ind}); 

%%
% Step 8. 
tt{ind+1} = tt{ind} + dt{ind}; 

%%
% End of algm_ggmr_orthogonal_steps_2_to_8.m
 
%%
% Function to determine the RQ factorization of a matrix C
function [R, Q] = rq(C)

[Q, L] = ql(C');
R = L'; 
Q = Q';

%%
% End of rq.m

%%
% Function to detemine the QL factorization of a matrix C
function [Q, L] = ql(C)

[m, n] = size(C);
[U, T] = qr(C(1:m, n:-1:1));
L = T(m:-1:1, n:-1:1);
Q = U(1:m, m:-1:1);

%%
% End of ql.m