%% Function to undertake steps 2 to 9 of the GGMR algorithm (Clause 10)
function [tt, dt, f, J, ft, Jt, g, H, M, q] = ... 
  algm_ggmr_cholesky_steps_2_to_9(x, y, U, tt, dt, f, J, ft, Jt, g, H, M, q, ind)

%%
% Step 2. 
m = length(x); 
f{ind} = [x - tt{ind}(1:m); 
          y - (tt{ind}(m+1) + tt{ind}(m+2)*tt{ind}(1:m))]; 
J{ind} = [-eye(m), zeros(m, 2); 
          -tt{ind}(m+2)*eye(m), -ones(m, 1), -tt{ind}(1:m)]; 

%%
% Step 3. 
L = chol(U, 'lower'); 

%%
% Step 4. 
ft{ind} = L\f{ind}; 
Jt{ind} = L\J{ind}; 

%%
% Step 5. 
g{ind} = Jt{ind}'*ft{ind}; 
H{ind} = Jt{ind}'*Jt{ind}; 

%%
% Step 6. 
M{ind} = chol(H{ind}, 'lower'); 

%%
% Step 7. 
q{ind} = -M{ind}\g{ind}; 

%%
% Step 8. 
dt{ind} = M{ind}'\q{ind}; 

%%
% Step 9. 
tt{ind+1} = tt{ind} + dt{ind}; 

%%
% End of algm_ggmr_cholesky_steps_2_to_9.m